/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterSpell;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetSpell;

class NivmagusElementalCost
extends CostImpl {
    private static final FilterSpell filter = new FilterInstantOrSorcerySpell("an instant or sorcery spell you control");

    NivmagusElementalCost() {
        TargetSpell target = new TargetSpell(filter);
        target.withNotTarget(true);
        this.addTarget((Target)target);
        this.text = "Exile an instant or sorcery spell you control";
    }

    private NivmagusElementalCost(NivmagusElementalCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return false;
        }
        player.chooseTarget(Outcome.Exile, (Target)this.getTargets().get(0), source, game);
        Spell spell = game.getSpell(this.getTargets().getFirstTarget());
        if (spell == null) {
            return false;
        }
        String spellName = spell.getName();
        if (spell.isCopy()) {
            game.getStack().remove((StackObject)spell, game);
        } else {
            player.moveCards((Card)spell, Zone.EXILED, source, game);
        }
        this.paid = true;
        game.informPlayers(player.getLogName() + " exiles " + spellName + " (as costs)");
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    public NivmagusElementalCost copy() {
        return new NivmagusElementalCost(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

