/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;

class NoWitnessesEffect
extends OneShotEffect {
    NoWitnessesEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player who controls the most creatures investigates";
    }

    private NoWitnessesEffect(NoWitnessesEffect effect) {
        super((OneShotEffect)effect);
    }

    public NoWitnessesEffect copy() {
        return new NoWitnessesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Map map = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game).stream().filter(Objects::nonNull).map(Controllable::getControllerId).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        if (map.isEmpty()) {
            return false;
        }
        int maxValue = map.values().stream().mapToInt(x -> x).max().orElse(0);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (map.getOrDefault(playerId, -1) < maxValue) continue;
            InvestigateEffect.doInvestigate((UUID)playerId, (int)1, (Game)game, (Ability)source);
        }
        return true;
    }
}

