/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class NobleBenefactorEffect
extends OneShotEffect {
    NobleBenefactorEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may search their library for a card and put that card into their hand. Then each player who searched their library this way shuffles";
    }

    private NobleBenefactorEffect(NobleBenefactorEffect effect) {
        super((OneShotEffect)effect);
    }

    public NobleBenefactorEffect copy() {
        return new NobleBenefactorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                TargetCardInLibrary target = new TargetCardInLibrary();
                if (!player.chooseUse(Outcome.Benefit, "Search your library for a card to put into your hand?", source, game)) continue;
                player.searchLibrary(target, source, game);
                for (UUID cardId : target.getTargets()) {
                    Card card = player.getLibrary().getCard(cardId, game);
                    if (card == null) continue;
                    player.moveCards(card, Zone.HAND, source, game);
                }
                player.shuffleLibrary(source, game);
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

