/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class NonHumanCannonballEffect
extends OneShotEffect {
    NonHumanCannonballEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. If the result is 4 or less, {this} deals that much damage to you";
    }

    private NonHumanCannonballEffect(NonHumanCannonballEffect effect) {
        super((OneShotEffect)effect);
    }

    public NonHumanCannonballEffect copy() {
        return new NonHumanCannonballEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 6);
        if (result <= 4) {
            player.damage(result, source, game);
        }
        return true;
    }
}

