/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class NorinSwiftSurvivalistEffect
extends OneShotEffect {
    NorinSwiftSurvivalistEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it. You may play that card from exile this turn";
    }

    private NorinSwiftSurvivalistEffect(NorinSwiftSurvivalistEffect effect) {
        super((OneShotEffect)effect);
    }

    public NorinSwiftSurvivalistEffect copy() {
        return new NorinSwiftSurvivalistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        if (card != null) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false, (UUID)player.getId(), null);
        }
        return true;
    }
}

