/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.FaerieRogueToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.watchers.common.AmountOfDamageAPlayerReceivedThisTurnWatcher;

class NotoriousThrongEffect
extends OneShotEffect {
    NotoriousThrongEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create X 1/1 black Faerie Rogue creature tokens with flying, where X is the damage dealt to your opponents this turn";
    }

    private NotoriousThrongEffect(NotoriousThrongEffect effect) {
        super((OneShotEffect)effect);
    }

    public NotoriousThrongEffect copy() {
        return new NotoriousThrongEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        AmountOfDamageAPlayerReceivedThisTurnWatcher watcher = (AmountOfDamageAPlayerReceivedThisTurnWatcher)game.getState().getWatcher(AmountOfDamageAPlayerReceivedThisTurnWatcher.class);
        if (controller != null && watcher != null) {
            int numTokens = 0;
            for (UUID opponentId : game.getOpponents(controller.getId())) {
                numTokens += watcher.getAmountOfDamageReceivedThisTurn(opponentId);
            }
            if (numTokens > 0) {
                new CreateTokenEffect((Token)new FaerieRogueToken(), numTokens).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

