/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class NoxiousGearhulkEffect
extends OneShotEffect {
    NoxiousGearhulkEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "you may destroy another target creature. If a creature is destroyed this way, you gain life equal to its toughness";
    }

    private NoxiousGearhulkEffect(NoxiousGearhulkEffect effect) {
        super((OneShotEffect)effect);
    }

    public NoxiousGearhulkEffect copy() {
        return new NoxiousGearhulkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent creatureToDestroy = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creatureToDestroy != null && player != null && player.chooseUse(Outcome.DestroyPermanent, "Destroy creature?", source, game) && creatureToDestroy.destroy(source, game, false)) {
            player.gainLife(creatureToDestroy.getToughness().getValue(), game, source);
        }
        return true;
    }
}

