/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.SpellsCastWatcher;

class NullstoneGargoyleTriggeredAbility
extends TriggeredAbilityImpl {
    public NullstoneGargoyleTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CounterTargetEffect(), false);
    }

    private NullstoneGargoyleTriggeredAbility(NullstoneGargoyleTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NullstoneGargoyleTriggeredAbility copy() {
        return new NullstoneGargoyleTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        if (spell.isCreature(game)) {
            return false;
        }
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        if (watcher != null && watcher.getNumberOfNonCreatureSpells() == 1) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever the first noncreature spell of a turn is cast, counter that spell.";
    }
}

