/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class NumbingDoseTriggeredAbility
extends TriggeredAbilityImpl {
    NumbingDoseTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(1), false);
    }

    private NumbingDoseTriggeredAbility(NumbingDoseTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public NumbingDoseTriggeredAbility copy() {
        return new NumbingDoseTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        Permanent equipment = game.getPermanent(this.getSourceId());
        if (equipment != null && (permanent = game.getPermanent(equipment.getAttachedTo())) != null && event.getPlayerId().equals(permanent.getControllerId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "At the beginning of the upkeep of enchanted permanent's controller, that player loses 1 life.";
    }
}

