/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class NyleasPresenceLandTypeEffect
extends ContinuousEffectImpl {
    NyleasPresenceLandTypeEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "Enchanted land is every basic land type in addition to its other types";
        this.dependencyTypes.add(DependencyType.BecomePlains);
        this.dependencyTypes.add(DependencyType.BecomeIsland);
        this.dependencyTypes.add(DependencyType.BecomeSwamp);
        this.dependencyTypes.add(DependencyType.BecomeMountain);
        this.dependencyTypes.add(DependencyType.BecomeForest);
    }

    private NyleasPresenceLandTypeEffect(NyleasPresenceLandTypeEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public NyleasPresenceLandTypeEffect copy() {
        return new NyleasPresenceLandTypeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return true;
        }
        Permanent land = game.getPermanent(enchantment.getAttachedTo());
        if (land == null) {
            return true;
        }
        land.addSubType(game, (Collection)SubType.getBasicLands());
        land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
        land.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
        land.addAbility((Ability)new BlackManaAbility(), source.getSourceId(), game);
        land.addAbility((Ability)new RedManaAbility(), source.getSourceId(), game);
        land.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
        return true;
    }
}

