/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetSacrifice;

class NyssaOfTrakenEffect
extends OneShotEffect {
    NyssaOfTrakenEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice any number of artifacts. When you sacrifice one or more artifacts this way, tap up to that many target creatures and draw that many cards.";
    }

    private NyssaOfTrakenEffect(NyssaOfTrakenEffect effect) {
        super((OneShotEffect)effect);
    }

    public NyssaOfTrakenEffect copy() {
        return new NyssaOfTrakenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACTS);
        player.choose(this.outcome, (Target)target, source, game);
        int count = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || !permanent.sacrifice(source, game)) continue;
            ++count;
        }
        if (count < 1) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new TapTargetEffect(), false);
        ability.addEffect((Effect)new DrawCardSourceControllerEffect(count).concatBy("and"));
        ability.addTarget((Target)new TargetCreaturePermanent(0, count));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

