/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.n;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DevotionCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.game.Game;
import mage.players.Player;

class NyxLotusDynamicManaEffect
extends ManaEffect {
    NyxLotusDynamicManaEffect() {
        this.staticText = "Choose a color. Add an amount of mana of that color equal to your devotion to that color. <i>(Your devotion to a color is the number of mana symbols of that color in the mana costs of permanents you control.)</i>";
    }

    private NyxLotusDynamicManaEffect(NyxLotusDynamicManaEffect effect) {
        super((ManaEffect)effect);
    }

    public NyxLotusDynamicManaEffect copy() {
        return new NyxLotusDynamicManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        if (game != null) {
            return ChoiceColor.getBaseColors().stream().map(s -> this.computeMana((String)s, game, source)).filter(mana -> mana.count() > 0).collect(Collectors.toList());
        }
        return new ArrayList<Mana>();
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return mana;
        }
        ChoiceColor choice = new ChoiceColor();
        choice.setMessage("Choose a color for devotion of Nyx Lotus");
        if (!controller.choose(this.outcome, (Choice)choice, game)) {
            return mana;
        }
        return this.computeMana(choice.getChoice(), game, source);
    }

    private Mana computeMana(String color, Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null || color == null || color.isEmpty()) {
            return mana;
        }
        switch (color) {
            case "White": {
                mana.setWhite(DevotionCount.W.calculate(game, source, (Effect)this));
                break;
            }
            case "Blue": {
                mana.setBlue(DevotionCount.U.calculate(game, source, (Effect)this));
                break;
            }
            case "Black": {
                mana.setBlack(DevotionCount.B.calculate(game, source, (Effect)this));
                break;
            }
            case "Red": {
                mana.setRed(DevotionCount.R.calculate(game, source, (Effect)this));
                break;
            }
            case "Green": {
                mana.setGreen(DevotionCount.G.calculate(game, source, (Effect)this));
            }
        }
        return mana;
    }
}

