/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class OathOfGhoulsEffect
extends OneShotEffect {
    OathOfGhoulsEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player chooses target player whose graveyard has fewer creature cards in it than their graveyard does and is their opponent. The first player may return a creature card from their graveyard to their hand";
    }

    private OathOfGhoulsEffect(OathOfGhoulsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        MageObject sourceObject = game.getObject(source);
        Player firstPlayer = game.getPlayer(game.getActivePlayerId());
        if (sourceObject == null || firstPlayer == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card");
        filter.add((Predicate)new OwnerIdPredicate(firstPlayer.getId()));
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)filter);
        target.withNotTarget(true);
        if (target.canChoose(firstPlayer.getId(), source, game) && firstPlayer.chooseUse(this.outcome, "Return a creature card from your graveyard to your hand?", source, game) && firstPlayer.chooseTarget(Outcome.ReturnToHand, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            firstPlayer.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }

    public OathOfGhoulsEffect copy() {
        return new OathOfGhoulsEffect(this);
    }
}

