/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ObeliskOfUrdBoostEffect
extends ContinuousEffectImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    ObeliskOfUrdBoostEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Creatures you control of the chosen type get +2/+2.";
    }

    private ObeliskOfUrdBoostEffect(ObeliskOfUrdBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ObeliskOfUrdBoostEffect copy() {
        return new ObeliskOfUrdBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
            if (subType != null) {
                for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                    if (!perm.hasSubtype(subType, game)) continue;
                    perm.addPower(2);
                    perm.addToughness(2);
                }
            } else {
                this.discard();
            }
        }
        return true;
    }
}

