/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class ObscuraConfluenceReturnEffect
extends OneShotEffect {
    ObscuraConfluenceReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "target player returns a creature card from their graveyard to their hand";
    }

    private ObscuraConfluenceReturnEffect(ObscuraConfluenceReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public ObscuraConfluenceReturnEffect copy() {
        return new ObscuraConfluenceReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
    }
}

