/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.EnteredThisTurnPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OcelotPrideEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("token you control that entered the battlefield this turn");

    OcelotPrideEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "for each token you control that entered the battlefield this turn, create a token that's a copy of it";
    }

    private OcelotPrideEffect(OcelotPrideEffect effect) {
        super((OneShotEffect)effect);
    }

    public OcelotPrideEffect copy() {
        return new OcelotPrideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        List tokensToCopy = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game);
        for (Permanent toCopy : tokensToCopy) {
            result |= new CreateTokenCopyTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(toCopy, game)).apply(game, source);
        }
        return result;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        filter.add((Predicate)EnteredThisTurnPredicate.instance);
    }
}

