/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OddOrEvenEffect
extends OneShotEffect {
    private boolean odd = true;

    public OddOrEvenEffect(boolean odd) {
        super(Outcome.DestroyPermanent);
        this.odd = odd;
        this.staticText = "Destroy each creature with an " + (odd ? "odd" : "even") + " number of words in its name. (Hyphenated words are one word.)";
    }

    private OddOrEvenEffect(OddOrEvenEffect effect) {
        super((OneShotEffect)effect);
        this.odd = effect.odd;
    }

    public OddOrEvenEffect copy() {
        return new OddOrEvenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game)) {
                boolean nameIsOdd;
                if (creature == null) continue;
                String name = creature.getName();
                if (name.equalsIgnoreCase("") && !this.odd) {
                    creature.destroy(source, game, false);
                    continue;
                }
                int spaces = name.length() - name.replace(" ", "").length();
                boolean bl = nameIsOdd = spaces % 2 == 0;
                if ((!this.odd || !nameIsOdd) && (this.odd || nameIsOdd)) continue;
                creature.destroy(source, game, false);
            }
        }
        return false;
    }
}

