/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OkkAttackEffect
extends RestrictionEffect {
    private static final FilterAttackingCreature filter = new FilterAttackingCreature("Attacking creatures");

    public OkkAttackEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless a creature with greater power also attacks";
    }

    private OkkAttackEffect(OkkAttackEffect effect) {
        super((RestrictionEffect)effect);
    }

    public OkkAttackEffect copy() {
        return new OkkAttackEffect(this);
    }

    public boolean canAttackCheckAfter(int numberOfAttackers, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                if (creature.getPower().getValue() <= permanent.getPower().getValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

