/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.HexproofAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class OkoTheRingleaderCopySelfEffect
extends OneShotEffect {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
            blueprint.getAbilities().add((Object)HexproofAbility.getInstance());
            return true;
        }
    };

    OkoTheRingleaderCopySelfEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} becomes a copy of up to one target creature you control until end of turn, except he has hexproof";
    }

    private OkoTheRingleaderCopySelfEffect(OkoTheRingleaderCopySelfEffect effect) {
        super((OneShotEffect)effect);
    }

    public OkoTheRingleaderCopySelfEffect copy() {
        return new OkoTheRingleaderCopySelfEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || creature == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, creature, permanent.getId(), source, applier);
        return true;
    }
}

