/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OkoTheRingleaderCopyTokenEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent();

    OkoTheRingleaderCopyTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each other nonland permanent you control, create a token that's a copy of that permanent";
    }

    private OkoTheRingleaderCopyTokenEffect(OkoTheRingleaderCopyTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public OkoTheRingleaderCopyTokenEffect copy() {
        return new OkoTheRingleaderCopyTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            new CreateTokenCopyTargetEffect().setSavedPermanent(permanent).apply(game, source);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

