/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class OldGrowthDryadsEffect
extends OneShotEffect {
    OldGrowthDryadsEffect() {
        super(Outcome.Detriment);
        this.staticText = "each opponent may search their library for a basic land card, put it onto the battlefield tapped, then shuffle";
    }

    private OldGrowthDryadsEffect(OldGrowthDryadsEffect effect) {
        super((OneShotEffect)effect);
    }

    public OldGrowthDryadsEffect copy() {
        return new OldGrowthDryadsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<Player> playersThatSearched = new HashSet<Player>(1);
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Card targetCard;
            TargetCardInLibrary target;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.chooseUse(Outcome.PutLandInPlay, "Search your library for a basic land card and put it onto the battlefield tapped?", source, game) || !opponent.searchLibrary(target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), source, game) || (targetCard = opponent.getLibrary().getCard(target.getFirstTarget(), game)) == null) continue;
            opponent.moveCards(targetCard, Zone.BATTLEFIELD, source, game, true, false, false, null);
            playersThatSearched.add(opponent);
        }
        for (Player opponent : playersThatSearched) {
            opponent.shuffleLibrary(source, game);
        }
        return true;
    }
}

