/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OmoQueenOfVesuvaCreatureEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterNonlandPermanent();

    public OmoQueenOfVesuvaCreatureEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "each nonland creature with an everything counter on it is every creature type";
        this.dependendToTypes.add(DependencyType.BecomeCreature);
        this.dependencyTypes.add(DependencyType.AddingCreatureType);
    }

    private OmoQueenOfVesuvaCreatureEffect(OmoQueenOfVesuvaCreatureEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public OmoQueenOfVesuvaCreatureEffect copy() {
        return new OmoQueenOfVesuvaCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game)) {
            permanent.setIsAllCreatureTypes(game, true);
        }
        return true;
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        filter.add((Predicate)CounterType.EVERYTHING.getPredicate());
    }
}

