/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.AnyColorManaAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class OmoQueenOfVesuvaLandEffect
extends ContinuousEffectImpl {
    private static final Ability[] basicManaAbilities = new Ability[]{new WhiteManaAbility(), new BlueManaAbility(), new BlackManaAbility(), new RedManaAbility(), new GreenManaAbility()};
    private static final FilterPermanent filter = new FilterLandPermanent();

    public OmoQueenOfVesuvaLandEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "each land with an everything counter on it is every land type in addition to its other types";
        this.dependendToTypes.add(DependencyType.BecomeMountain);
        this.dependendToTypes.add(DependencyType.BecomeForest);
        this.dependendToTypes.add(DependencyType.BecomeSwamp);
        this.dependendToTypes.add(DependencyType.BecomeIsland);
        this.dependendToTypes.add(DependencyType.BecomePlains);
    }

    private OmoQueenOfVesuvaLandEffect(OmoQueenOfVesuvaLandEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public OmoQueenOfVesuvaLandEffect copy() {
        return new OmoQueenOfVesuvaLandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game)) {
            permanent.addSubType(game, new SubType[]{SubType.PLAINS, SubType.ISLAND, SubType.SWAMP, SubType.MOUNTAIN, SubType.FOREST});
            permanent.setIsAllNonbasicLandTypes(game, true);
            for (Ability basicManaAbility : basicManaAbilities) {
                if (!permanent.getAbilities(game).containsRule(basicManaAbility)) continue;
                permanent.removeAbility(basicManaAbility, source.getSourceId(), game);
            }
            AnyColorManaAbility ability = new AnyColorManaAbility();
            if (permanent.getAbilities(game).containsRule((Ability)ability)) continue;
            permanent.addAbility((Ability)ability, source.getSourceId(), game);
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterType.EVERYTHING.getPredicate());
    }
}

