/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AdamantCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileSpellEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class OnceAndFutureEffect
extends OneShotEffect {
    OnceAndFutureEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target card from your graveyard to your hand. Put up to one other target card from your graveyard on top of your library. Exile {this}.<br><i>Adamant</i> &mdash; If at least three green mana was spent to cast this spell, instead return those cards to your hand and exile {this}.";
    }

    private OnceAndFutureEffect(OnceAndFutureEffect effect) {
        super((OneShotEffect)effect);
    }

    public OnceAndFutureEffect copy() {
        return new OnceAndFutureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card1 = game.getCard(source.getFirstTarget());
        Card card2 = game.getCard(((Target)source.getTargets().get(1)).getFirstTarget());
        if (this.getCondition().apply(game, source)) {
            CardsImpl cards = new CardsImpl(card1);
            cards.add(card2);
            player.moveCards((Cards)cards, Zone.HAND, source, game);
        } else {
            player.moveCards(card1, Zone.HAND, source, game);
            game.processAction();
            player.putCardsOnTopOfLibrary(card2, game, source, true);
        }
        game.processAction();
        return new ExileSpellEffect().apply(game, source);
    }

    public Condition getCondition() {
        return AdamantCondition.GREEN;
    }
}

