/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.watchers.Watcher;

class OpalPalaceWatcher
extends Watcher {
    private final List<UUID> commanderPartsId = new ArrayList<UUID>();
    private final String originalId;

    public OpalPalaceWatcher(String originalId) {
        super(WatcherScope.CARD);
        this.originalId = originalId;
    }

    public boolean manaUsedToCastCommanderPart(UUID id) {
        return this.commanderPartsId.contains(id);
    }

    public void watch(GameEvent event, Game game) {
        Card card;
        Spell spell;
        if (event.getType() == GameEvent.EventType.MANA_PAID && event.getData() != null && event.getData().equals(this.originalId) && (spell = game.getStack().getSpell(event.getTargetId())) != null && (card = spell.getCard()) != null) {
            for (UUID playerId : game.getPlayerList()) {
                Player player = game.getPlayer(playerId);
                if (player == null || !game.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, true).contains(card.getId())) continue;
                this.commanderPartsId.add(card.getId());
                break;
            }
        }
    }

    public void reset() {
        super.reset();
        this.commanderPartsId.clear();
    }
}

