/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class Opalescence
extends CardImpl {
    public Opalescence(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}{W}");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new OpalescenceEffect()));
    }

    private Opalescence(Opalescence card) {
        super((CardImpl)card);
    }

    public Opalescence copy() {
        return new Opalescence(this);
    }

    static class OpalescenceEffect
    extends ContinuousEffectImpl {
        private static final FilterEnchantmentPermanent filter = new FilterEnchantmentPermanent("Each other non-Aura enchantment");

        public OpalescenceEffect() {
            super(Duration.WhileOnBattlefield, Outcome.BecomeCreature);
            this.staticText = "Each other non-Aura enchantment is a creature in addition to its other types and has base power and base toughness each equal to its mana value";
            this.dependendToTypes.add(DependencyType.EnchantmentAddingRemoving);
            this.dependendToTypes.add(DependencyType.AuraAddingRemoving);
            this.dependencyTypes.add(DependencyType.BecomeCreature);
        }

        private OpalescenceEffect(OpalescenceEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public OpalescenceEffect copy() {
            return new OpalescenceEffect(this);
        }

        public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                switch (layer) {
                    case TypeChangingEffects_4: {
                        if (sublayer != SubLayer.NA || permanent.isCreature(game)) break;
                        permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                        break;
                    }
                    case PTChangingEffects_7: {
                        if (sublayer != SubLayer.SetPT_7b) break;
                        int manaCost = permanent.getManaValue();
                        permanent.getPower().setModifiedBaseValue(manaCost);
                        permanent.getToughness().setModifiedBaseValue(manaCost);
                    }
                }
            }
            return true;
        }

        public boolean apply(Game game, Ability source) {
            return false;
        }

        public boolean hasLayer(Layer layer) {
            return layer == Layer.PTChangingEffects_7 || layer == Layer.TypeChangingEffects_4;
        }

        static {
            filter.add(Predicates.not((Predicate)SubType.AURA.getPredicate()));
            filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        }
    }
}

