/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class OpenTheWayEffect
extends OneShotEffect {
    OpenTheWayEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal X land cards. Put those land cards onto the battlefield tapped and the rest on the bottom of your library in a random order";
    }

    private OpenTheWayEffect(OpenTheWayEffect effect) {
        super((OneShotEffect)effect);
    }

    public OpenTheWayEffect copy() {
        return new OpenTheWayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || xValue < 1) {
            return false;
        }
        CardsImpl toReveal = new CardsImpl();
        CardsImpl lands = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (card.isLand(game)) {
                lands.add(card);
            }
            if (lands.size() < xValue) continue;
            break;
        }
        player.revealCards(source, (Cards)toReveal, game);
        player.moveCards(lands.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        toReveal.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }
}

