/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class OppressiveRaysCostModificationEffect
extends CostModificationEffectImpl {
    OppressiveRaysCostModificationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Activated abilities of enchanted creature cost {3} more to activate";
    }

    private OppressiveRaysCostModificationEffect(OppressiveRaysCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)3);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Permanent creature = game.getPermanent(abilityToModify.getSourceId());
        return creature != null && creature.getAttachments().contains(source.getSourceId()) && abilityToModify.isActivatedAbility();
    }

    public OppressiveRaysCostModificationEffect copy() {
        return new OppressiveRaysCostModificationEffect(this);
    }
}

