/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.AttackedThisTurnWatcher;

class OracleEnVecDestroyEffect
extends OneShotEffect {
    private final List<UUID> chosenCreatures;

    OracleEnVecDestroyEffect(List<UUID> chosenCreatures) {
        super(Outcome.DestroyPermanent);
        this.chosenCreatures = chosenCreatures;
        this.staticText = "destroy each of the chosen creatures that didn't attack";
    }

    private OracleEnVecDestroyEffect(OracleEnVecDestroyEffect effect) {
        super((OneShotEffect)effect);
        this.chosenCreatures = effect.chosenCreatures;
    }

    public OracleEnVecDestroyEffect copy() {
        return new OracleEnVecDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        AttackedThisTurnWatcher watcher = (AttackedThisTurnWatcher)game.getState().getWatcher(AttackedThisTurnWatcher.class);
        if (watcher != null) {
            for (UUID targetId : this.chosenCreatures) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null || watcher.getAttackedThisTurnCreatures().contains(new MageObjectReference((MageObject)permanent, game))) continue;
                DestroyTargetEffect effect = new DestroyTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetId, game));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

