/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.LanderToken;

class OrbitalPlungeEffect
extends OneShotEffect {
    OrbitalPlungeEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 6 damage to target creature. If excess damage was dealt this way, create a Lander token.";
    }

    private OrbitalPlungeEffect(OrbitalPlungeEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrbitalPlungeEffect copy() {
        return new OrbitalPlungeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (permanent.damageWithExcess(6, source, game) > 0) {
            new LanderToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

