/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OrchardElementalEffect
extends OneShotEffect {
    OrchardElementalEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for sprout or harvest. Put two +1/+1 counters on {this} for each sprout vote. You gain 3 life for each harvest vote";
    }

    private OrchardElementalEffect(OrchardElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrchardElementalEffect copy() {
        return new OrchardElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Sprout (two +1/+1 counters)", "Harvest (3 life)", Outcome.Benefit);
        vote.doVotes(source, game);
        int sproutCount = vote.getVoteCount((Object)true);
        int harvestCount = vote.getVoteCount((Object)false);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (sproutCount > 0 && permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(2 * sproutCount), source.getControllerId(), source, game);
        }
        Player player = game.getPlayer(source.getControllerId());
        if (harvestCount > 0 && player != null) {
            player.gainLife(3 * harvestCount, game, source);
        }
        return sproutCount + harvestCount > 0;
    }
}

