/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OrcishCaptainEffect
extends OneShotEffect {
    OrcishCaptainEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, target Orc creature gets +2/+0 until end of turn. If you lose the flip, it gets -0/-2 until end of turn";
    }

    private OrcishCaptainEffect(OrcishCaptainEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent != null) {
            if (controller.flipCoin(source, game, true)) {
                game.informPlayers("Orcish Captain: Won flip. Target Orc creature gets +2/+0 until end of turn.");
                game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 0, Duration.EndOfTurn), source);
                return true;
            }
            game.informPlayers("Orcish Captain: Lost flip. Target Orc creature gets -0/-2 until end of turn.");
            game.addEffect((ContinuousEffect)new BoostTargetEffect(0, -2, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }

    public OrcishCaptainEffect copy() {
        return new OrcishCaptainEffect(this);
    }
}

