/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageAttachedControllerEffect;
import mage.abilities.effects.common.DestroyAttachedToEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class OrcishMineAbility
extends TriggeredAbilityImpl {
    public OrcishMineAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyAttachedToEffect("enchanted land"));
        this.addEffect((Effect)new DamageAttachedControllerEffect(2));
    }

    private OrcishMineAbility(OrcishMineAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_REMOVED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent p;
        if (event.getData().equals(CounterType.ORE.getName()) && event.getTargetId().equals(this.getSourceId()) && (p = game.getPermanent(this.getSourceId())) != null) {
            return p.getCounters(game).getCount(CounterType.ORE) == 0;
        }
        return false;
    }

    public OrcishMineAbility copy() {
        return new OrcishMineAbility(this);
    }

    public String getRule() {
        return "When the last ore counter is removed from {this}, destroy enchanted land and {this} deals 2 damage to that land's controller.";
    }
}

