/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceLeftOrRight;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OrderOfSuccessionEffect
extends OneShotEffect {
    OrderOfSuccessionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Starting with you and proceeding in the chosen direction, each player chooses a creature controlled by the next player in that direction. Each player gains control of the creature they chose";
    }

    private OrderOfSuccessionEffect(OrderOfSuccessionEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrderOfSuccessionEffect copy() {
        return new OrderOfSuccessionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashMap<UUID, UUID> playerCreature = new HashMap<UUID, UUID>(2);
            ChoiceLeftOrRight choice = new ChoiceLeftOrRight();
            if (!controller.choose(Outcome.Neutral, (Choice)choice, game)) {
                return false;
            }
            boolean left = choice.getChoice().equals("Left");
            PlayerList playerList = game.getState().getPlayerList().copy();
            while (!((UUID)playerList.get()).equals(source.getControllerId()) && controller.canRespond()) {
                playerList.getNext();
            }
            Player currentPlayer = game.getPlayer((UUID)playerList.get());
            UUID firstNextPlayer = null;
            while (!this.getNextPlayerInDirection(left, playerList, game).equals(firstNextPlayer) && controller.canRespond()) {
                Player nextPlayer = game.getPlayer((UUID)playerList.get());
                if (nextPlayer == null) {
                    return false;
                }
                if (firstNextPlayer == null) {
                    firstNextPlayer = nextPlayer.getId();
                }
                if (!nextPlayer.canRespond()) continue;
                if (currentPlayer != null && game.getState().getPlayersInRange(controller.getId(), game).contains((Object)currentPlayer.getId())) {
                    FilterCreaturePermanent filter = new FilterCreaturePermanent("creature controlled by " + nextPlayer.getLogName());
                    filter.add((Predicate)new ControllerIdPredicate(nextPlayer.getId()));
                    TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                    target.withNotTarget(true);
                    if (target.canChoose(currentPlayer.getId(), source, game) && currentPlayer.chooseTarget(this.outcome, (Target)target, source, game)) {
                        playerCreature.put(currentPlayer.getId(), target.getFirstTarget());
                    }
                }
                currentPlayer = nextPlayer;
            }
            for (Map.Entry entry : playerCreature.entrySet()) {
                Permanent creature;
                Player player = game.getPlayer((UUID)entry.getKey());
                if (player == null || (creature = game.getPermanent((UUID)entry.getValue())) == null) continue;
                GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame, player.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
                game.informPlayers(player.getLogName() + " gains control of " + creature.getName());
            }
            return true;
        }
        return false;
    }

    private UUID getNextPlayerInDirection(boolean left, PlayerList playerList, Game game) {
        UUID nextPlayerId = left ? (UUID)playerList.getNext() : (UUID)playerList.getPrevious();
        return nextPlayerId;
    }
}

