/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OrmosArchiveKeeperEffect
extends ReplacementEffectImpl {
    OrmosArchiveKeeperEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card while your library has no cards in it, instead put five +1/+1 counters on {this}";
    }

    private OrmosArchiveKeeperEffect(OrmosArchiveKeeperEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public OrmosArchiveKeeperEffect copy() {
        return new OrmosArchiveKeeperEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(5), source.getControllerId(), source, game);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player;
        return event.getPlayerId().equals(source.getControllerId()) && (player = game.getPlayer(event.getPlayerId())) != null && !player.hasLost() && !player.getLibrary().hasCards();
    }
}

