/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.o.OrnateKanzashiCastFromExileEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OrnateKanzashiEffect
extends OneShotEffect {
    OrnateKanzashiEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent exiles the top card of their library. You may play that card this turn";
    }

    private OrnateKanzashiEffect(OrnateKanzashiEffect effect) {
        super((OneShotEffect)effect);
    }

    public OrnateKanzashiEffect copy() {
        return new OrnateKanzashiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && opponent != null) {
            Library library;
            Card card;
            if (opponent.getLibrary().hasCards() && (card = (library = opponent.getLibrary()).getFromTop(game)) != null) {
                opponent.moveCardToExileWithInfo(card, source.getSourceId(), sourceObject.getName(), source, game, Zone.LIBRARY, true);
                OrnateKanzashiCastFromExileEffect effect = new OrnateKanzashiCastFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

