/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class OtherworldAtlasDrawEffect
extends OneShotEffect {
    OtherworldAtlasDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Each player draws a card for each charge counter on {this}";
    }

    private OtherworldAtlasDrawEffect(OtherworldAtlasDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public OtherworldAtlasDrawEffect copy() {
        return new OtherworldAtlasDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && sourcePlayer != null && (amount = permanent.getCounters(game).getCount(CounterType.CHARGE)) > 0) {
            for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.drawCards(amount, source, game);
            }
        }
        return true;
    }
}

