/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class OupheVandalsEffect
extends OneShotEffect {
    OupheVandalsEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target activated ability from an artifact source and destroy that artifact if it's on the battlefield.";
    }

    private OupheVandalsEffect(OupheVandalsEffect effect) {
        super((OneShotEffect)effect);
    }

    public OupheVandalsEffect copy() {
        return new OupheVandalsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        StackObject stackObject = game.getStack().getStackObject(targetId);
        if (targetId != null && game.getStack().counter(targetId, source, game)) {
            Permanent usedPermanent;
            UUID permanentId = stackObject.getSourceId();
            if (permanentId != null && (usedPermanent = game.getPermanent(permanentId)) != null) {
                usedPermanent.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

