/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AdamantCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OutmuscleEffect
extends OneShotEffect {
    OutmuscleEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put a +1/+1 counter on target creature you control, then it fights target creature you don't control. <i>(Each deals damage equal to its power to the other.)</i> <br><i>Adamant</i> &mdash; If at least three green mana was spent to cast this spell, the creature you control gains indestructible until end of turn.";
    }

    private OutmuscleEffect(OutmuscleEffect effect) {
        super((OneShotEffect)effect);
    }

    public OutmuscleEffect copy() {
        return new OutmuscleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (AdamantCondition.GREEN.apply(game, source)) {
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        Permanent creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (creature == null) {
            return true;
        }
        game.processAction();
        return creature.fight(permanent, source, game);
    }

    public Condition getCondition() {
        return AdamantCondition.GREEN;
    }
}

