/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantAttackAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class OverencumberedEffect
extends OneShotEffect {
    OverencumberedEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may pay {1} for each artifact they control. If they don't, creatures can't attack this combat.";
    }

    private OverencumberedEffect(OverencumberedEffect effect) {
        super((OneShotEffect)effect);
    }

    public OverencumberedEffect copy() {
        return new OverencumberedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player enchantedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (enchantedPlayer == null || controller == null) {
            return false;
        }
        int amount = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT, enchantedPlayer.getId(), game);
        if (!new GenericManaCost(amount).pay(source, game, source, enchantedPlayer.getId(), false)) {
            game.addEffect((ContinuousEffect)new CantAttackAllEffect(Duration.EndOfCombat, StaticFilters.FILTER_PERMANENT_CREATURES), source);
        }
        return true;
    }
}

