/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class OverlordOfTheBalemurkEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("non-Avatar creature card or a planeswalker card from your graveyard");

    OverlordOfTheBalemurkEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may return a non-Avatar creature card or a planeswalker card from your graveyard to your hand";
    }

    private OverlordOfTheBalemurkEffect(OverlordOfTheBalemurkEffect effect) {
        super((OneShotEffect)effect);
    }

    public OverlordOfTheBalemurkEffect copy() {
        return new OverlordOfTheBalemurkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, filter, true);
        player.choose(Outcome.PutCreatureInPlay, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)Predicates.and((Predicate)Predicates.not((Predicate)SubType.AVATAR.getPredicate()), (Predicate)CardType.CREATURE.getPredicate()), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

