/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.o.OwlbearCubEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OwlbearCubTriggeredAbility
extends TriggeredAbilityImpl {
    OwlbearCubTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new OwlbearCubEffect());
        this.withFlavorWord("Mama's Coming");
        this.setTriggerPhrase("Whenever {this} attacks a player who controls eight or more lands, ");
    }

    private OwlbearCubTriggeredAbility(OwlbearCubTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public OwlbearCubTriggeredAbility copy() {
        return new OwlbearCubTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().contains(this.getSourceId())) {
            return false;
        }
        Player player = game.getPlayer(game.getCombat().getDefenderId(this.getSourceId()));
        if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, player.getId(), (Ability)this, game) < 8) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(player.getId()));
        return true;
    }
}

