/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.o;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.ManaUtil;

class SpellSyphonEffect
extends OneShotEffect {
    SpellSyphonEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell unless its controller pays {1} for each card in your hand";
    }

    private SpellSyphonEffect(SpellSyphonEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellSyphonEffect copy() {
        return new SpellSyphonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && spell != null) {
            Player player = game.getPlayer(spell.getControllerId());
            Player controller = game.getPlayer(source.getControllerId());
            if (player != null && controller != null) {
                ManaCost cost;
                int amount = controller.getHand().size();
                if (amount > 0 && !(cost = ManaUtil.createManaCost((int)amount, (boolean)false)).pay(source, game, source, spell.getControllerId(), false)) {
                    game.informPlayers(sourceObject.getLogName() + ": cost wasn't payed - countering target spell.");
                    return game.getStack().counter(source.getFirstTarget(), source, game);
                }
                return true;
            }
        }
        return false;
    }
}

