/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashSet;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.WebSlingingAbility;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class AmazingSpiderManEffect
extends ContinuousEffectImpl {
    static final FilterCard filter = new FilterCard("legendary spell that's one or more colors");

    AmazingSpiderManEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each legendary spell you cast that's one or more colors has web-slinging {G}{W}{U}";
    }

    private AmazingSpiderManEffect(AmazingSpiderManEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AmazingSpiderManEffect copy() {
        return new AmazingSpiderManEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet cardsToGainAbility = new HashSet();
        cardsToGainAbility.addAll(controller.getHand().getCards(filter, game));
        cardsToGainAbility.addAll(controller.getGraveyard().getCards(filter, game));
        controller.getLibrary().getCards(game).stream().filter(c -> filter.match(c, game)).forEach(cardsToGainAbility::add);
        game.getExile().getCardsInRange(game, controller.getId()).stream().filter(c -> filter.match(c, game)).forEach(cardsToGainAbility::add);
        game.getCommanderCardsFromCommandZone(controller, CommanderCardType.ANY).stream().filter(c -> filter.match(c, game)).forEach(cardsToGainAbility::add);
        game.getStack().stream().filter(Spell.class::isInstance).filter(s -> s.isControlledBy(controller.getId())).filter(s -> filter.match((Card)((Spell)s), game)).map(s -> game.getCard(s.getSourceId())).filter(Objects::nonNull).forEach(cardsToGainAbility::add);
        for (Card card : cardsToGainAbility) {
            WebSlingingAbility ability = new WebSlingingAbility(card, "{G}{W}{U}");
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getControllerOrOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)ColorlessPredicate.instance));
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
    }
}

