/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class PacksBetrayal
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent();
    private static final Condition condition;
    private static final Hint hint;

    public PacksBetrayal(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{2}{R}");
        this.getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addEffect((Effect)new GainControlTargetEffect(Duration.EndOfTurn));
        this.getSpellAbility().addEffect((Effect)new UntapTargetEffect().setText("Untap that creature"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("It gains haste until end of turn."));
        this.getSpellAbility().addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new ScryEffect(2), condition, "If you control a Wolf or Werewolf, scry 2"));
        this.getSpellAbility().addHint(hint);
    }

    private PacksBetrayal(PacksBetrayal card) {
        super((CardImpl)card);
    }

    public PacksBetrayal copy() {
        return new PacksBetrayal(this);
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.WOLF.getPredicate(), (Predicate)SubType.WEREWOLF.getPredicate()));
        condition = new PermanentsOnTheBattlefieldCondition(filter);
        hint = new ConditionHint(condition, "You control a Wolf or Werewolf");
    }
}

