/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.ChosenSubtypePredicate;
import mage.game.Game;
import mage.players.Player;

class PactOfTheSerpentEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    PactOfTheSerpentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player draws X cards and loses X life, where X is the number of creatures they control of the chosen type";
    }

    private PactOfTheSerpentEffect(PactOfTheSerpentEffect effect) {
        super((OneShotEffect)effect);
    }

    public PactOfTheSerpentEffect copy() {
        return new PactOfTheSerpentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        int permCount = game.getBattlefield().count(filter, player.getId(), source, game);
        if (permCount > 0) {
            player.drawCards(permCount, source, game);
            player.loseLife(permCount, game, source, false);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ChosenSubtypePredicate.TRUE);
    }
}

