/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class PainfulMemoriesEffect
extends OneShotEffect {
    PainfulMemoriesEffect() {
        super(Outcome.Discard);
        this.staticText = "Look at target opponent's hand and choose a card from it. Put that card on top of that player's library.";
    }

    private PainfulMemoriesEffect(PainfulMemoriesEffect effect) {
        super((OneShotEffect)effect);
    }

    public PainfulMemoriesEffect copy() {
        return new PainfulMemoriesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player you = game.getPlayer(source.getControllerId());
        if (targetPlayer != null && you != null) {
            targetPlayer.revealCards("Painful Memories", targetPlayer.getHand(), game);
            if (!targetPlayer.getHand().isEmpty()) {
                Card card;
                TargetCard target = new TargetCard(Zone.HAND, new FilterCard());
                if (you.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game) && (card = targetPlayer.getHand().get(target.getFirstTarget(), game)) != null) {
                    return targetPlayer.moveCardToLibraryWithInfo(card, source, game, Zone.HAND, true, true);
                }
            }
            return true;
        }
        return false;
    }
}

