/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PainiacEffect
extends OneShotEffect {
    PainiacEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. {this} gets +X/+0 until end of turn, where X is the result";
    }

    private PainiacEffect(PainiacEffect effect) {
        super((OneShotEffect)effect);
    }

    public PainiacEffect copy() {
        return new PainiacEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            int amount = controller.rollDice(this.outcome, source, game, 6);
            game.addEffect((ContinuousEffect)new BoostSourceEffect(amount, 0, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

