/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class PaleMoonReplacementEffect
extends ReplacementEffectImpl {
    PaleMoonReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "Until end of turn, if a player taps a nonbasic land for mana, it produces colorless mana instead of any other type";
    }

    private PaleMoonReplacementEffect(PaleMoonReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PaleMoonReplacementEffect copy() {
        return new PaleMoonReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ManaEvent manaEvent = (ManaEvent)event;
        Mana mana = manaEvent.getMana();
        mana.setToMana(Mana.ColorlessMana((int)mana.count()));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game) && !permanent.isBasic(game);
    }
}

