/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ParallelEvolutionEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public ParallelEvolutionEffect() {
        super(Outcome.Neutral);
        this.staticText = "For each creature token on the battlefield, its controller creates a token that's a copy of that creature";
    }

    private ParallelEvolutionEffect(ParallelEvolutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ParallelEvolutionEffect copy() {
        return new ParallelEvolutionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(permanent.getControllerId());
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

